import { makeStyles } from '@material-ui/core/styles';
import { GREYISH_BROWN, BUTTON_COLOR } from 'constants/colors';

const useStyles = makeStyles(() => ({
    currentVersion: {
        opacity: 0.8,
        fontFamily: 'Lato',
        fontSize: 16,
        lineHeight: 1.5,
        textAlign: 'center',
        marginBottom: 5,
        color: GREYISH_BROWN
    },
    newVersionAvailableContainer: {
        display: 'flex',
        flexDirection: 'column',
        alignItems: 'center',
        marginTop: 12
    },
    newVersionAvailableTitle: {
        fontFamily: 'Roboto-Condensed',
        fontSize: 22,
        fontWeight: 'bold',
        fontStyle: 'normal',
        lineHeight: 1.27,
        letterSpacing: 0.68,
        textAlign: 'center',
        color: GREYISH_BROWN
    },
    newVersionAvailableSubContainer: {
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        marginTop: 16,
        marginBottom: 30
    },
    whatsNew: {
        fontSize: 16,
        fontWeight: 'normal',
        fontStretch: 'normal',
        fontStyle: 'normal',
        lineHeight: 1.5,
        letterSpacing: 'normal',
        textAlign: 'center',
        color: BUTTON_COLOR,
        cursor: 'pointer'
    },
    languageContainer: {
        marginTop: 0,
        marginBottom: 10,
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        width: '300px',
        position: 'relative',
        justifyContent: 'center'
    },
    fwLanguageTitle: {
        fontWeight: 'bold'
    },
    languageInput: {
        color: '#000000 !important',
        border: '0 !important',
        fontFamily: 'Lato, Arial, Helvetica, Helvetica Neue, serif !important',
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        marginLeft: 10,
        '& img': {
            marginRight: 5,
            marginTop: 4,
            width: 26,
            height: 22
        }
    },
    languageSelect: {
        display: 'flex !important',
        '& img': {
            marginRight: 5,
            marginTop: 0,
            width: 26,
            height: 22
        }
    },
    languageInputArrow: {
        color: `${BUTTON_COLOR} !important`
    },
    selectedMenuItem: {
        display: 'none'
    },
    languageMenuItem: {
        color: '#000000',
        '& img': {
            marginRight: 5,
            marginTop: 0,
            width: 26,
            height: 22
        }
    }
}));

export default useStyles;
